
CREATE OR REPLACE PROCEDURE installLogSeg (param1 IN VARCHAR2, param2 IN VARCHAR2, param3 IN VARCHAR2, 
 param4 IN DATE, param5 IN VARCHAR2, param6 IN VARCHAR2, param7 IN NUMBER) IS

 CURSOR  curseur IS SELECT p.nomPoste, p.nPoste, s.nomSalle
   FROM  Poste p, Salle s
   WHERE p.indIP  = param1 AND p.typePoste = param6
   AND   p.nSalle = s.nSalle;

 p_nomSegment Segment.nomSegment%TYPE;
 toutsePasseBien BOOLEAN := TRUE;
 date_fausse          EXCEPTION;
 pas_install_possible EXCEPTION;
 enfant_sans_parent   EXCEPTION;
 PRAGMA EXCEPTION_INIT(enfant_sans_parent,-2291);
 nbrInstall  NUMBER := 0;
BEGIN
 BEGIN
   --  numro de segment inconnu?
  SELECT nomSegment INTO p_nomSegment FROM Segment WHERE indIP  = param1 ;
  EXCEPTION
      WHEN NO_DATA_FOUND THEN
	toutsePasseBien := FALSE;
        DBMS_OUTPUT.PUT_LINE('Segment inconnu!');
      WHEN OTHERS THEN
	toutsePasseBien := FALSE;
        DBMS_OUTPUT.PUT_LINE('Erreur d''Oracle ' || SQLERRM  || '(' || SQLCODE || ')');
 END;
 IF param4 > SYSDATE THEN RAISE date_fausse;
 END IF;
 IF toutsePasseBien THEN

  INSERT INTO Logiciel VALUES (param2,param3,param4,param5,param6,param7,0);
  DBMS_OUTPUT.PUT_LINE(param3 || ' stock dans la table Logiciel');
	
  FOR enreg IN curseur LOOP
   nbrInstall  := nbrInstall + 1;
   INSERT INTO Installer VALUES(enreg .nPoste, param2, sequenceIns.NEXTVAL ,SYSDATE, 
	NUMTODSINTERVAL(SYSDATE-param4,'DAY'));
   DBMS_OUTPUT.PUT_LINE('Installation sur '|| enreg.nomPoste ||' dans ' || enreg.nomSalle);
  END LOOP;

  COMMIT;
  IF nbrInstall = 0 THEN 
    RAISE pas_install_possible;
  ELSE
    DBMS_OUTPUT.PUT_LINE(nbrInstall  || ' installations ont t faites.');
  END IF;
 END IF;

EXCEPTION
  WHEN enfant_sans_parent THEN
    --  leve de  type inconnu
    DBMS_OUTPUT.PUT_LINE('Type de logiciel inconnu!');
  WHEN DUP_VAL_ON_INDEX THEN
    --  logiciel dja prsent
    DBMS_OUTPUT.PUT_LINE('Logiciel dja prsent!');
  WHEN date_fausse THEN
    -- date d'achat > date_jour  : date_fausse
    DBMS_OUTPUT.PUT_LINE('Date d''achat suprieure  celle du jour!');
  WHEN pas_install_possible THEN
    -- aucune installation posssible sur ce segment
    DBMS_OUTPUT.PUT_LINE('Pas de poste de ce type sur le segment');
  WHEN OTHERS THEN
       DBMS_OUTPUT.PUT_LINE('Erreur d''Oracle ' ||
                 SQLERRM  || '(' || SQLCODE || ')');
END installLogSeg ;
/


SET SERVEROUT ON
--Mauvais segment
EXECUTE installLogSeg('130.120.87', 'log99','Blaster', '05-09-2003', '9.9', 'PCWS', 999.9 )

--Logiciel dj prsent
EXECUTE installLogSeg('130.120.80', 'log6','Blaster', '05-09-2003', '9.9', 'PCWS', 999.9 )


--date > jour
EXECUTE installLogSeg('130.120.80', 'log66','Blaster', '05-09-3000', '9.9', 'PCWS', 999.9 )


--Type de logiciel inconnu
EXECUTE installLogSeg('130.120.80', 'log66','Blaster', '05-09-2003', '9.9', 'APPL', 999.9 )


--Aucune install
EXECUTE installLogSeg('130.120.81', 'log55','Eudora5', '05-09-2003', '5', 'PCWS', 55 )


--Bonne installation
EXECUTE installLogSeg('130.120.80', 'log66','Eudora6', '10-09-2003', '6.0', 'PCWS', 66 )

SELECT * FROM Logiciel;
SELECT * FROM Installer;
